// PlikiDzwiekoweDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PlikiDzwiekowe.h"
#include "PlikiDzwiekoweDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#include "wave.h"
#include "mmsystem.h"
#pragma comment(lib, "Winmm.lib")

// CPlikiDzwiekoweDlg dialog




CPlikiDzwiekoweDlg::CPlikiDzwiekoweDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPlikiDzwiekoweDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPlikiDzwiekoweDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_SLIDER1, slider1);
	DDX_Control(pDX, IDC_SLIDER2, slider2);
}

BEGIN_MESSAGE_MAP(CPlikiDzwiekoweDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON1, &CPlikiDzwiekoweDlg::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &CPlikiDzwiekoweDlg::OnBnClickedButton2)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER1, &CPlikiDzwiekoweDlg::OnNMCustomdrawSlider1)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER2, &CPlikiDzwiekoweDlg::OnNMCustomdrawSlider1)
END_MESSAGE_MAP()


// CPlikiDzwiekoweDlg message handlers

BOOL CPlikiDzwiekoweDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	
	USHORT kanalLewy, kanalPrawy;
	CzytajPoziomGlosnosciWave(kanalLewy, kanalPrawy);
	
	slider1.SetRangeMin(0);
	slider1.SetRangeMax(100);
    slider1.SetTicFreq(15);
	slider1.SetPos(kanalLewy);
   
	slider2.SetRangeMin(0);
	slider2.SetRangeMax(100);
    slider2.SetTicFreq(15);
    slider2.SetPos(kanalPrawy);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPlikiDzwiekoweDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPlikiDzwiekoweDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CPlikiDzwiekoweDlg::OnBnClickedButton1()
{
	if (CzyJestKartaDzwiekowa()) 
		MessageBox(L"Brak karty dwikowej!");
	else 
		MessageBox(L"Karta dwikowa jest zainstalowana");

}

void CPlikiDzwiekoweDlg::OnBnClickedButton2()
{
	//PlaySound(L"c:\\WINDOWS\\MEDIA\\Windows Logon Sound.wav", 0, SND_FILENAME | SND_ASYNC);
	PlaySound((LPCTSTR)SND_ALIAS_SYSTEMSTART, NULL, SND_ALIAS_ID);
}

void CPlikiDzwiekoweDlg::OnNMCustomdrawSlider1(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	// TODO: Add your control notification handler code here
	*pResult = 0;

	UstalPoziomGlosnosciWave(slider1.GetPos(), slider2.GetPos());
}

